<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Guardian extends Model 
{

    protected $table = 'guardians';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'relationship', 'address', 'tel_no');

    public function user()
    {
        return $this->belongsTo('\User');
    }

}